/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.teastory.registry;

import cloud.lemonslice.teastory.block.crops.HybridizableFlowerBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.registries.DeferredRegister;
import xueluoanping.teastory.TeaStory;
import xueluoanping.teastory.registry.BlockRegister;

public class ModBiomeFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registries.f_256833_, (String)"teastory");

    public static class TeaPlacedFeature {
        public static final ResourceKey<PlacedFeature> WILD_RICE = TeaPlacedFeature.createKey("wild_rice");
        public static final ResourceKey<PlacedFeature> WILD_CHILI = TeaPlacedFeature.createKey("wild_chili");
        public static final ResourceKey<PlacedFeature> WILD_CHINESE_CABBAGE = TeaPlacedFeature.createKey("wild_chinese_cabbage");
        public static final ResourceKey<PlacedFeature> WILD_GRAPE = TeaPlacedFeature.createKey("wild_grape");
        public static final ResourceKey<PlacedFeature> WILD_CUCUMBER = TeaPlacedFeature.createKey("wild_cucumber");
        public static final ResourceKey<PlacedFeature> WILD_BITTER_GOURD = TeaPlacedFeature.createKey("wild_bitter_gourd");
        public static final ResourceKey<PlacedFeature> WILD_TEA_PLANT = TeaPlacedFeature.createKey("wild_tea_plant");
        public static final ResourceKey<PlacedFeature> GRASS_BLOCK_WITH_HOLE = TeaPlacedFeature.createKey("grass_block_with_hole");
        public static final ResourceKey<PlacedFeature> FLOWER_PATCH = TeaPlacedFeature.createKey("flower_patch");

        private static ResourceKey<PlacedFeature> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)TeaStory.rl(name));
        }

        public static List<PlacementModifier> worldSurfaceSquaredWithCount(int pCount, int chance) {
            return List.of(CountPlacement.m_191628_((int)pCount), RarityFilter.m_191900_((int)chance), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_());
        }

        public static void bootstrap(BootstapContext<PlacedFeature> context) {
            HolderGetter holdergetter = context.m_255420_(Registries.f_256911_);
            PlacementUtils.m_254943_(context, WILD_RICE, (Holder)holdergetter.m_255043_(TeaConfiguredFeature.WILD_RICE), TeaPlacedFeature.worldSurfaceSquaredWithCount(2, 24));
            PlacementUtils.m_254943_(context, WILD_CHILI, (Holder)holdergetter.m_255043_(TeaConfiguredFeature.WILD_CHILI), TeaPlacedFeature.worldSurfaceSquaredWithCount(3, 32));
            PlacementUtils.m_254943_(context, WILD_CHINESE_CABBAGE, (Holder)holdergetter.m_255043_(TeaConfiguredFeature.WILD_CHINESE_CABBAGE), TeaPlacedFeature.worldSurfaceSquaredWithCount(4, 28));
            PlacementUtils.m_254943_(context, WILD_GRAPE, (Holder)holdergetter.m_255043_(TeaConfiguredFeature.WILD_GRAPE), TeaPlacedFeature.worldSurfaceSquaredWithCount(3, 32));
            PlacementUtils.m_254943_(context, WILD_CUCUMBER, (Holder)holdergetter.m_255043_(TeaConfiguredFeature.WILD_CUCUMBER), TeaPlacedFeature.worldSurfaceSquaredWithCount(2, 42));
            PlacementUtils.m_254943_(context, WILD_BITTER_GOURD, (Holder)holdergetter.m_255043_(TeaConfiguredFeature.WILD_BITTER_GOURD), TeaPlacedFeature.worldSurfaceSquaredWithCount(3, 32));
            PlacementUtils.m_254943_(context, WILD_TEA_PLANT, (Holder)holdergetter.m_255043_(TeaConfiguredFeature.WILD_TEA_PLANT), TeaPlacedFeature.worldSurfaceSquaredWithCount(5, 24));
            PlacementUtils.m_254943_(context, GRASS_BLOCK_WITH_HOLE, (Holder)holdergetter.m_255043_(TeaConfiguredFeature.GRASS_BLOCK_WITH_HOLE), TeaPlacedFeature.worldSurfaceSquaredWithCount(3, 20));
            PlacementUtils.m_254943_(context, FLOWER_PATCH, (Holder)holdergetter.m_255043_(TeaConfiguredFeature.FLOWER_PATCH), TeaPlacedFeature.worldSurfaceSquaredWithCount(2, 5));
        }
    }

    public static class TeaConfiguredFeature {
        public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_RICE = TeaConfiguredFeature.createKey("wild_rice");
        public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_CHILI = TeaConfiguredFeature.createKey("wild_chili");
        public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_CHINESE_CABBAGE = TeaConfiguredFeature.createKey("wild_chinese_cabbage");
        public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_GRAPE = TeaConfiguredFeature.createKey("wild_grape");
        public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_CUCUMBER = TeaConfiguredFeature.createKey("wild_cucumber");
        public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_BITTER_GOURD = TeaConfiguredFeature.createKey("wild_bitter_gourd");
        public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_TEA_PLANT = TeaConfiguredFeature.createKey("wild_tea_plant");
        public static final ResourceKey<ConfiguredFeature<?, ?>> GRASS_BLOCK_WITH_HOLE = TeaConfiguredFeature.createKey("grass_block_with_hole");
        public static final ResourceKey<ConfiguredFeature<?, ?>> FLOWER_PATCH = TeaConfiguredFeature.createKey("flower_patch");

        private static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)TeaStory.rl(name));
        }

        private static RandomPatchConfiguration grassLikePatch(BlockStateProvider pStateProvider, int pTries) {
            return TeaConfiguredFeature.simpleRandomPatchConfiguration(pTries, (Holder<PlacedFeature>)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration(pStateProvider)));
        }

        private static RandomPatchConfiguration onDirtCrop(BlockStateProvider pStateProvider, int pTries) {
            BlockPredicate predicate = BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_220864_, Blocks.f_50129_, Blocks.f_49994_}), (BlockPredicate)BlockPredicate.m_224780_((Block[])new Block[]{Blocks.f_50016_}));
            return TeaConfiguredFeature.simpleRandomPatchConfiguration(pTries, (Holder<PlacedFeature>)PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration(pStateProvider), (BlockPredicate)predicate));
        }

        private static RandomPatchConfiguration onDirtReplace(BlockState blockState, int pTries) {
            BlockPredicate predicate = BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.m_224774_((Vec3i)Direction.UP.m_122436_(), (Block[])new Block[]{Blocks.f_50016_}), (BlockPredicate)BlockPredicate.m_224780_((Block[])new Block[]{Blocks.f_50440_}));
            return TeaConfiguredFeature.simpleRandomPatchConfiguration(pTries, (Holder<PlacedFeature>)PlacementUtils.m_206498_((Feature)Feature.f_159732_, (FeatureConfiguration)new ReplaceBlockConfiguration(Blocks.f_50440_.m_49966_(), blockState), (BlockPredicate)predicate));
        }

        public static RandomPatchConfiguration simpleRandomPatchConfiguration(int pTries, Holder<PlacedFeature> pFeature) {
            return new RandomPatchConfiguration(pTries, 4, 3, pFeature);
        }

        public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
            FeatureUtils.m_254977_(context, WILD_RICE, (Feature)Feature.f_65763_, (FeatureConfiguration)TeaConfiguredFeature.onDirtCrop((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegister.WILD_RICE.get())), 4));
            FeatureUtils.m_254977_(context, WILD_CHILI, (Feature)Feature.f_65763_, (FeatureConfiguration)TeaConfiguredFeature.grassLikePatch((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegister.WILD_CHILI.get())), 4));
            FeatureUtils.m_254977_(context, WILD_CHINESE_CABBAGE, (Feature)Feature.f_65763_, (FeatureConfiguration)TeaConfiguredFeature.grassLikePatch((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegister.WILD_CHINESE_CABBAGE.get())), 5));
            FeatureUtils.m_254977_(context, WILD_GRAPE, (Feature)Feature.f_65763_, (FeatureConfiguration)TeaConfiguredFeature.grassLikePatch((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegister.WILD_GRAPE.get())), 42));
            FeatureUtils.m_254977_(context, WILD_CUCUMBER, (Feature)Feature.f_65763_, (FeatureConfiguration)TeaConfiguredFeature.grassLikePatch((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegister.WILD_CUCUMBER.get())), 68));
            FeatureUtils.m_254977_(context, WILD_BITTER_GOURD, (Feature)Feature.f_65763_, (FeatureConfiguration)TeaConfiguredFeature.grassLikePatch((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegister.WILD_BITTER_GOURD.get())), 72));
            FeatureUtils.m_254977_(context, WILD_TEA_PLANT, (Feature)Feature.f_65763_, (FeatureConfiguration)TeaConfiguredFeature.grassLikePatch((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegister.wild_tea_plant.get())), 6));
            FeatureUtils.m_254977_(context, GRASS_BLOCK_WITH_HOLE, (Feature)Feature.f_65763_, (FeatureConfiguration)TeaConfiguredFeature.onDirtReplace(((Block)BlockRegister.GRASS_BLOCK_WITH_HOLE.get()).m_49966_(), 4));
            FeatureUtils.m_254977_(context, FLOWER_PATCH, (Feature)Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(48, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new NoiseProvider(2345L, new NormalNoise.NoiseParameters(0, 1.0, new double[0]), 0.020833334f, Stream.of(BlockRegister.CHRYSANTHEMUM, BlockRegister.HYACINTH, BlockRegister.ZINNIA).map(o -> {
                BlockState state = ((HybridizableFlowerBlock)((Object)((Object)o.get()))).m_49966_();
                ArrayList list = new ArrayList();
                HybridizableFlowerBlock.FLOWER_COLOR.m_6908_().forEach(flowerColor -> list.add((BlockState)state.m_61124_(HybridizableFlowerBlock.FLOWER_COLOR, (Comparable)((Object)flowerColor))));
                return list;
            }).flatMap(Collection::stream).toList())))));
        }
    }
}

